#ifndef ARM_H
#define ARM_H

#include <roster.h>
#include <direction.h>
#include "stretch.h"

struct Arm : public Roster {
	Stretch *top;
	Stretch *bottom;
	Stretch *middle;
	Direction *dir;
	Atom *fist;
	bool *grab;
	bool *punch;
	double cur_ext;
	double ext_dir;
	int mode;
	bool punch_levels[MAXLEVELS];
	bool normal_levels[MAXLEVELS];
	Roster *held;
	bool punched;
	bool threw;
	bool throwing;
	float power;
	bool charging;

	Arm(Object *parent, Direction *dir, bool *grab, bool *punch);
	void grasp();
	void drop();
	void chuck();
	virtual void stepFunc();
	virtual void addAtom(Atom *a);
};

#endif